package ga.core.individual;

/**
 * Interface for the fitness.
 * 
 * @since 11.08.2012
 * @author Stephan Dreyer
 */
public interface IFitness {
  public static final double UNEVALUATED = Double.MIN_VALUE;

  /**
   * Setter for the fitness of the individual.
   * 
   * @param fitness
   *          The fitness.
   * 
   * @since 11.08.2012
   * @author Stephan Dreyer
   */
  public void setFitness(double fitness);

  /**
   * Getter for the fitness of the individual.
   * 
   * @return The fitness.
   * 
   * @since 11.08.2012
   * @author Stephan Dreyer
   */
  public double getFitness();
}
